<?php include 'services_content.php';
$serviceurl = basename($_SERVER['REQUEST_URI']);
$service = null;
foreach ($services as $s) {
  if ($s['link'] == $serviceurl) {
    $service = $s;
    break;
  }
}

$faqs = $service['faqs'];

?>

<?php include("./components/head.php"); ?>

<body class="bg-dark">

  <?php include("./components/preloader.php"); ?>

  <?php include("./components/navbar.php"); ?>

  <?php include("./components/hero-sec.php"); ?>

  <!-- Services Details Area -->
  <div class="services-details-area default-padding">
    <div class="container">
      <div class="services-details-items">
        <div class="row">

          <div class="col-xl-8 col-lg-7 pr-45 pr-md-15 pr-xs-15 services-single-content">
            <div class="service-single-thumb">
              <img src="<?= $service['img']; ?>" alt="Thumb">
            </div>
            <h2 class="title mb-4 text-primary"><?= $service['heading1']; ?></h2>
            <p class="mb-5"><?= $service['para1']; ?></p>
            <div class="features mt-40 mt-xs-30 mb-30 mb-xs-20">
              <div class="row">
                <div class="col-lg-5 col-md-6">
                  <div class="content">
                    <h3>Included Services</h3>
                    <ul class="feature-list-item">
                      <?php
                      $includes = explode(";", $service['includes']);
                      foreach ($includes as $include) {
                        echo '<li>' . $include . '</li>';
                      }
                      ?>
                    </ul>
                  </div>
                </div>
                <div class="col-lg-7 col-md-6 mt-xs-30">
                  <div class="content">
                    <h3 style="font-size: 24px;"><?= $service['heading2']; ?></h3>
                    <p><?= $service['para2']; ?></p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-xl-4 col-lg-5 mt-md-50 mt-xs-50 pl-30 pl-md-15 pl-xs-15 services-sidebar">
            <!-- Single Widget -->
            <div class="single-widget services-list-widget">
              <h4 class="widget-title">Services</h4>
              <ul>
                <?php foreach ($services as $s) : ?>
                  <li class="<?= $s['link'] === $serviceurl ? 'current-item' : ''; ?>">
                    <a href="<?= $s['link']; ?>">
                      <?= $s['title']; ?> <i
                        class="<?= $s['link'] === $serviceurl ? 'fas fa-stop-circle' : 'fas fa-arrow-right'; ?>"></i>
                    </a>
                  </li>
                <?php endforeach; ?>
              </ul>
            </div>
            <!-- End Single Widget -->
            <div class="single-widget quick-contact-widget bg-gradient text-light">
              <div class="content">
                <h3>Need Help?</h3>
                <p>
                  Speak with a human to filling out a form? call corporate office and we will connect.
                </p>
                <h2>+(012) 6679545</h2>
                <h4><a href="mailto:info@savvydesignhub.com">info@savvydesignhub.com</a></h4>
                <a class="btn mt-30 btn-sm circle btn-light effect" href="contact-us.html">Contact Now</a>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <h1>What we do?</h1>
            <p><?= $service['wwd']; ?></p>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="faq-style-one faq-style-two mt-40">
              <h2 class="mb-30">Any Questions find here.</h2>
              <div class="accordion" id="faqAccordion">
                <?php $count = 1;
                foreach ($faqs as $faq) : ?>
                  <div class="accordion-item">
                    <h2 class="accordion-header" id="heading<?= $count; ?>">
                      <button class="accordion-button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapse<?= $count; ?>" aria-expanded="true"
                        aria-controls="collapse<?= $count; ?>">
                        <?= $faq['question']; ?>
                      </button>
                    </h2>
                    <div id="collapse<?= $count; ?>" class="accordion-collapse collapse show"
                      aria-labelledby="heading<?= $count; ?>" data-bs-parent="#faqAccordion">
                      <div class="accordion-body">
                        <p><?= $faq['answer']; ?></p>
                      </div>
                    </div>
                  </div>
                <?php $count++;
                endforeach; ?>
              </div>
            </div>
            <div class="services-more mt-40">
              <h2 class="mb-20">Most popular services</h2>
              <div class="row">
                <div class="col-md-6">
                  <div class="item">
                    <img src="assets/img/icon/aim.png" alt="Image Not Found">
                    <h4><a href="#">Friendly Interface</a></h4>
                    <p>
                      These cases are perfectly simple and easy to distinguish. In a free hour, when our power.
                    </p>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="item">
                    <img src="assets/img/icon/email.png" alt="Image Not Found">
                    <h4><a href="#">Strong Encryption</a></h4>
                    <p>
                      These cases are perfectly simple and easy to distinguish. In a free hour, when our power.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php $logo = "03.png";
  include("./components/footer.php"); ?>

  <?php include("./components/js-scripts.php"); ?>
