<?php
$pricingPackages = [
  'logo_design' =>
  [
    [
      'id' => 1,
      'name' => 'Basic Logo',
      'url' => 'packages/basic-logo.php',
      'discounted_price' => '35',
      'price' => '117',
      'features' => [
        '4 Original Logo Concepts',
        '2 Dedicated Logo Designer',
        '4 Revisions',
        'With Grey Scale Format',
        'Free Icon Design',
        'Formats: JPEG Only',
        '24 - 48 Hours Turn Around Time',
        '100% Satisfaction',
        '100% Ownership Rights',
        'Money Back Guarantee',
        'Dedicated Account Manager',
      ],
    ],
    [
      'id' => 2,
      'name' => 'Professional Logo',
      'url' => 'packages/professional-logo.php',
      'discounted_price' => '119',
      'price' => '397',
      'features' => [
        '12 Original Logo Concepts',
        '4 Dedicated Logo Designer (Industry Specific)',
        'Unlimited Revisions',
        'Stationery Design (Business Card, Letterhead, Envelope)',
        'Email Signature Design',
        'With Grey Scale Format',
        'Free Icon Design',
        'Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG',
        '24 - 48 Hours Turn Around Time',
        '100% Satisfaction',
        '100% Ownership Rights',
        'Money Back Guarantee',
        'Dedicated Account Manager'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Elite Logo',
      'url' => 'packages/elite-logo',
      'discounted_price' => '299',
      'price' => '849',
      'features' => [
        'Unlimited Original Logo Concepts',
        '8 Dedicated Logo Designer (Industry Specific)',
        'Unlimited Revisions',
        'Stationery Design (Business Card, Letterhead, Envelope)',
        '500 Business Cards',
        'Email Signature Design',
        'With Grey Scale Format',
        'Free Icon Design',
        'Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG',
        '24 - 48 Hours Turn Around Time',
        '100% Satisfaction',
        'Money Back Guarantee',
        'Dedicated Account Manager'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Logo Aficionado',
      'url' => 'packages/logo-aficionado',
      'discounted_price' => '399',
      'price' => '599',
      'features' => [
        '3D/Mascot/Animated Logo',
        'Unlimited Original Logo Concepts',
        '8 Dedicated Logo Designer (Industry Specific)',
        'Unlimited Revisions',
        'Stationery Design (Business Card, Letterhead, Envelope)',
        '500 Business Cards',
        'Email Signature Design',
        'With Grey Scale Format',
        'Free Icon Design',
        'Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG',
        '24 - 48 Hours Turn Around Time',
        '100% Satisfaction',
        'Money Back Guarantee',
        'Dedicated Account Manager'
      ]
    ],
  ],
  'website_design' =>
  [
    [
      'id' => 1,
      'name' => 'Basic',
      'url' => 'packages/basic-website',
      'discounted_price' => '244',
      'price' => '488',
      'features' => [
        '3 Page Website',
        'Theme Based Design',
        'Stock Photography',
        'Responsive Design',
        'Turnaround 3 Days',
        'Social Media Integration',
        'Contact Forms Included',
        'Content Not Included!'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Startup',
      'url' => 'packages/startup-website',
      'discounted_price' => '494',
      'price' => '788',
      'features' => [
        '5 Page Website',
        'Theme Based Design',
        'Stock Photography',
        'Turnaround 4 Days',
        'Responsive Design',
        'Content Management System',
        'Social Media Integration',
        'Blog Setup',
        'Contact Forms Included'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Professional',
      'url' => 'packages/professional-website',
      'discounted_price' => '895',
      'price' => '1058',
      'features' => [
        '10 Page Website',
        'Custom Design',
        'Stock Photography',
        'Original Content',
        'Turnaround 7 Days',
        'Responsive Design',
        'Content Management System',
        'Sliders',
        'Social Media Integration',
        'SEO Features',
        'Blog Setup',
        'Contact Forms Included'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Elite',
      'url' => 'packages/elite-website',
      'discounted_price' => '1899',
      'price' => '2900',
      'features' => [
        'Dedicated Project Manager',
        'Upto 12-14 Unique Pages Website',
        'Conceptual And Dynamic Website',
        'Online Reservation/Appointment Tool (Optional)',
        'Custom Forms',
        'Lead Capturing Forms (Optional)',
        'Striking Hover Effects',
        'Newsletter Subscription (Optional)',
        'Newsfeed Integration',
        'Social Media Integration',
        'Search Engine Submission',
        'Mobile Responsive',
        '8 Stock Photos',
        '5 Unique Banner Design',
        '1 JQuery Slider Banner',
        '48 To 72 Hours TAT',
        'Complete Deployment',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 5,
      'name' => 'Identity',
      'url' => 'packages/identity-website',
      'discounted_price' => '3199',
      'price' => '4099',
      'features' => [
        'Dedicated Project Manager',
        '15 Seconds 2D Explainer Video',
        'Voice - Over & Sound Effects',
        'Professional Script Writing',
        'Storyboard',
        'SEO Meta Tags',
        'Unlimited Pages Website',
        'Custom Made, Interactive, Dynamic & High End Design',
        'Custom WP (Or) Custom PHP Development',
        '1 JQuery Slider Banner',
        'Up To 10 Custom Made Banner Designs',
        '10 Stock Images',
        'Unlimited Revisions',
        'Special Hover Effects',
        'Content Management System (CMS)',
        'Online Appointment/Scheduling/Online Ordering Integration (Optional)',
        'Online Payment Integration (Optional)',
        'Complete Deployment',
        'Multi Lingual (Optional)',
        'Custom Dynamic Forms (Optional)',
        'Signup Area (For Newsletters, Offers Etc.)',
        'Search Bar',
        'Live Feeds Of Social Networks Integration (Optional)',
        'Mobile Responsive',
        'FREE 5 Years Domain Name',
        'Free Google Friendly Sitemap',
        'Search Engine Submission',
        'Industry Specified Team Of Expert Designers And Developers',
        'Complete Deployment',
        'Dedicated Accounts Manager',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 6,
      'name' => 'Corporate',
      'url' => 'packages/corporate-website',
      'discounted_price' => '7999',
      'price' => '10999',
      'features' => [
        'Dedicated Project Manager',
        'Complete Custom Design & Development',
        'Complete Branding Solution',
        'Banner Designs',
        'Unique Logo Designs',
        'Unlimited Revisions',
        'Custom Portal',
        'Unique, User-Friendly, Interactive, Dynamic Layout'
      ]
    ]
  ],
  'illustration_design' =>
  [
    [
      'id' => 1,
      'name' => 'Basic Illustrations',
      'url' => 'packages/basic-illustrations',
      'discounted_price' => '294',
      'price' => '588',
      'features' => [
        'UNLIMITED Logo Design Concepts',
        'By 8 Award Winning Designers',
        'UNLIMITED Revisions',
        '2 Stationary Design Sets (Business Card, Letterhead, Envelope)',
        'Icon Design',
        'Double Sided Flyer Design / Bi-Fold Brochure',
        'FREE MS Word Letterhead',
        'Free Email Signature',
        'All Final Files Format (AI, PSD, EPS, PNG, GIF, JPG, PDF)',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        '100% Money Back Guarantee *'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Illustrations for Startups',
      'url' => 'packages/illustrations-for-startups',
      'discounted_price' => '394',
      'price' => '788',
      'features' => [
        '3 Custom Design Concepts',
        'By 2 Designers',
        'UNLIMITED Revisions',
        '48 to 72 hours TAT',
        'All Final Files Format (AI, PSD, EPS, PNG, GIF, JPG, PDF)',
        '100% Ownership Rights',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        '100% Money Back Guarantee *'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Professional Illustrations',
      'url' => 'packages/professional-illustrations',
      'discounted_price' => '594',
      'price' => '1188',
      'features' => [
        '4 Custom Design Concepts',
        'By 3 Designers',
        '48 to 72 hours TAT',
        'UNLIMITED Revisions',
        'All Final Files Format (AI, PSD, EPS, PNG, GIF, JPG, PDF)',
        '100% Ownership Rights',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        '100% Money Back Guarantee *'
      ]
    ],
    [
      'id' => 4,
      'name' => '3D Logo Package',
      'url' => 'packages/3d-logo-package',
      'discounted_price' => '644',
      'price' => '1088',
      'features' => [
        'UNLIMITED Logo Design Concepts',
        'By 8 Award Winning Designers',
        'Icon Design',
        'UNLIMITED Revisions',
        '2 Stationary Design Sets (Business Card, Letterhead, Envelope)',
        'FREE MS Word Letterhead',
        'Free Email Signature',
        '3 Page Custom Website',
        '2 Stock Photos',
        '2 Banner Designs',
        'jQuery Slider',
        'All Final Files Format (AI, PSD, EPS, PNG, GIF, JPG, PDF)',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        '100% Money Back Guarantee *'
      ]
    ],
    [
      'id' => 5,
      'name' => 'Business Logo',
      'url' => 'packages/business-logo',
      'discounted_price' => '345',
      'price' => '488',
      'features' => [
        '3 Unique 3D Logo Concepts',
        'Light Effects and VFX',
        'Fully Rendered',
        'Multiple 3D Angles',
        'By 3 Award Winning Designers',
        '72 hours Turnaround Time',
        'UNLIMITED Revisions',
        '100% Ownership Rights',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        '100% Money Back Guarantee *',
        'Special Hover Effects',
        'Content Management System (CMS)',
        'Online Appointment/Scheduling/Online Ordering Integration (Optional)',
        'Online Payment Integration (Optional)',
        'Complete Deployment',
        'Multi Lingual (Optional)',
        'Custom Dynamic Forms (Optional)',
        'Signup Area (For Newsletters, Offers Etc.)',
        'Search Bar',
        'Live Feeds Of Social Networks Integration (Optional)',
        'Mobile Responsive',
        'FREE 5 Years Domain Name',
        'Free Google Friendly Sitemap',
        'Search Engine Submission',
        'Industry Specified Team Of Expert Designers And Developers',
        'Dedicated Accounts Manager',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 6,
      'name' => 'Gold Logo',
      'url' => 'packages/gold-logo',
      'discounted_price' => '525',
      'price' => '849',
      'features' => [
        'UNLIMITED Logo Design Concepts',
        'By 4 Designers',
        'UNLIMITED Revisions',
        'Stationary Design (Business Card, Letterhead, Envelope)',
        'FREE MS Word Letterhead',
        '48 to 72 hours TAT',
        'All Final Files Format (AI, PSD, EPS, PNG, GIF, JPG, PDF)*'
      ]
    ]
  ],
  'creative_copywriting' =>
  [
    [
      'id' => 1,
      'name' => 'Basic',
      'url' => 'packages/basic-copywriting',
      'discounted_price' => '199',
      'price' => '319',
      'features' => [
        '1 Page Professional Copywriting Service',
        'Creative & Well-Written by 1 Professional Copywriter',
        'Industry Specified Expert Copywriter',
        '300 Words Per Page',
        '5 Revisions',
        '3 to 4 Business Days Rotation',
        'According To Your Exact Requirements',
        'Proofing by our in-house experts',
        '100% Original Content',
        '100% Approval Assurance',
        '30 Days Refund Warranty',
        'Mobile Responsive',
        'Social Media Integration (Facebook, Instagram & Twitter)',
        '6 Months Complimentary Website Maintenance',
        'Newsletter Subscription',
        'Unlimited Revisions',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Starter',
      'url' => 'packages/starter-copywriting',
      'discounted_price' => '599',
      'price' => '1119',
      'features' => [
        '5 Pages Professional Copywriting Service',
        'Creative & Well-Written by 2 Professional Copywriters',
        'Industry Specified Expert Copywriters',
        '300 Words Per Page',
        '10 Revisions',
        '5 to 7 Business Days Rotation',
        'According To Your Exact Requirements',
        'Proofing by our in-house experts',
        'Free Meta Tags Creation',
        'Keyword Mapping',
        '100% Ownership Rights',
        '100% Original Content',
        '100% Approval Assurance',
        '30 Days Refund Warranty'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Advanced',
      'url' => 'packages/advanced-copywriting',
      'discounted_price' => '1849',
      'price' => '4619',
      'features' => [
        '10 Pages Professional Copywriting Service',
        'Creative & Well-Written by 3 Professional Copywriters',
        'Industry Specified Expert Copywriters',
        '300 Words Per Page',
        'Unlimited Revisions',
        '7 to 10 Business Days Rotation',
        'According To Your Exact Requirements',
        'Proofing by our in-house experts',
        'Free Meta Tags Creation',
        'Keyword Mapping',
        '100% Ownership Rights',
        '100% Original Content',
        '100% Approval Assurance',
        '30 Days Refund Warranty'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Proficient',
      'url' => 'packages/proficient-copywriting',
      'discounted_price' => '1049',
      'price' => '2119',
      'features' => [
        'Up To 20 Pages Professional Copywriting Service',
        'Creative & Well-Written by 3 Professional Copywriters',
        'Industry Specified Expert Copywriters',
        '300 Words Per Page',
        'Unlimited Revisions',
        '7 to 10 Business Days Rotation',
        'According To Your Exact Requirements',
        'Proofing by our in-house experts',
        'Free Meta Tags Creation',
        'Keyword Mapping',
        '100% Ownership Rights',
        '100% Original Content',
        '100% Approval Assurance',
        '30 Days Refund Warranty'
      ]
    ]
  ],
  'seo_services' =>
  [
    [
      'id' => 1,
      'name' => 'Basic',
      'url' => 'packages/basic-seo',
      'price' => '1000',
      'features' => [
        'Campaign Setup',
        'Website Audit',
        '15 Selected Keywords Targeting',
        'Keyword Research',
        'Keyword Grouping',
        'Keyword Mapping',
        'SEO Road Map',
        'Blog Creation',
        'Webpage Copywriting (3 Pages, 350 Words Per Page)',
        'Title Tag Optimization (10 Titles)',
        'Meta Description Optimization (10 Meta Descriptions)',
        'Meta Keyword Optimization (10 Meta Keywords)',
        'Domain Redirect Optimization (10 Domain Redirects)',
        'XML Sitemap Optimization',
        'Robots.Txt Check',
        'URL Rewrites (10 URL Rewrites)',
        'Broken Link Report',
        'Rich Snippet Recommendations',
        'Breadcrumbs',
        'Initial Off-Page SEO',
        'Social Bookmarking',
        'Slide Share Marketing',
        'Forums/FAQ’s',
        'Link Building',
        'Directory Submission',
        'Local Business Listings',
        '10 Submissions',
        '10 Classifieds',
        '10 Community Participation',
        '10 Business Profiles',
        'Meta Tags Creation',
        'Web Content Optimization',
        'Keyword Optimization',
        'Anchor Text Optimization',
        'Google Analytics Installation',
        'Monthly Progress Report',
        'Dedicated Project Manager',
        'Support, 5 Days a Week'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Premium',
      'url' => 'packages/premium-seo',
      'price' => '1500',
      'features' => [
        'Prior Analysis',
        'Business Analysis',
        'Consumer Analysis',
        'Competitor Analysis',
        '35 Selected Keywords Targeting',
        '15 Pages Keyword Targeted',
        'Meta Tags Creation',
        'Keyword Optimization',
        'Image Optimization',
        'Inclusion Of Anchors',
        'Tracking & Analysis',
        'Google Analytics Installation',
        'Google Webmaster Installation',
        'Call To Action Plan',
        'Creation Of Sitemaps',
        'Reporting',
        'Monthly Reporting',
        'Recommendation',
        'Email Support',
        'Phone Support',
        'Social Bookmarking',
        'Slide Share Marketing',
        'Forums/FAQs',
        'Link Building',
        'Directory Submission',
        'Local Business Listings',
        '15 Submissions',
        '15 Classifieds',
        '15 Community Participation',
        '15 Business Profiles',
        'Meta Tags Creation',
        'Web Content Optimization',
        'Keyword Optimization',
        'Anchor Text Optimization',
        'Image Optimization',
        'Google Analytics Installation',
        'Monthly Progress Report',
        'Dedicated Project Manager',
        'Support, 5 Days a Week'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Platinum',
      'url' => 'packages/platinum-seo',
      'price' => '2500',
      'features' => [
        'Campaign Setup',
        'Prior Analysis',
        'Business Analysis',
        'Consumer Analysis',
        'Competitor Analysis',
        '60+ Selected Keywords Targeting',
        '30 Pages Keyword Targeted',
        'Meta Tags Creation',
        'Keyword Optimization',
        'Image Optimization',
        'Inclusion Of Anchors Tags',
        'Inclusion Of Anchors Indexing Modifications',
        'Tracking & Analysis',
        'Google Analytics Installation',
        'Google Webmaster Installation',
        'Call To Action Plan',
        'Creation Of Sitemaps',
        'Reporting',
        'Monthly Reporting',
        'Recommendation',
        'Email Support',
        'Phone Support',
        'Off Page Optimization',
        'Social Bookmarking',
        'Slide Share Marketing',
        'Forums/FAQs',
        'Link Building',
        'Directory Submission',
        'Local Business Listings',
        'Local SEO'
      ]
    ]
  ],
  'ecommerce_web_solutions' =>
  [
    [
      'id' => 1,
      'name' => 'Basic',
      'url' => 'packages/basic-ecommerce',
      'discounted_price' => '499',
      'price' => '999',
      'features' => [
        'Customized Design',
        'Up-To 50 Products',
        'Content Management System (CMS)',
        'Mini Shopping Cart Integration',
        'Payment Module Integration',
        'Easy Product Search',
        'Mobile Responsive',
        'Dedicated Designer & Developer',
        'Unlimited Revisions',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Startup',
      'url' => 'packages/startup-ecommerce',
      'discounted_price' => '999',
      'price' => '1399',
      'features' => [
        'Customized Design',
        'Up-To 100 Products',
        'Content Management System (CMS)',
        'Mini Shopping Cart Integration',
        'Payment Module Integration',
        'Easy Product Search',
        'Mobile Responsive',
        'Dedicated Designer & Developer',
        'Unlimited Revisions',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Professional',
      'url' => 'packages/professional-ecommerce',
      'discounted_price' => '1799',
      'price' => '2399',
      'features' => [
        'Customized Design',
        'Up-To 500 Products',
        'Content Management System (CMS)',
        'Full Shopping Cart Integration',
        'Payment Module Integration',
        'Easy Product Search',
        'Product Reviews',
        '5 Promotional Banners',
        'Mobile Responsive',
        'Team Of Expert Designers & Developers',
        'Unlimited Revisions',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Identity',
      'url' => 'packages/identity-ecommerce',
      'discounted_price' => '2999',
      'price' => '3399',
      'features' => [
        'Dedicated Project Manager',
        'Unlimited Pages Website',
        'Customized Designed Logo',
        'Unlimited Products',
        'Mobile Responsive + Mobile Friendly',
        'Content Management System (CMS)',
        'Full Shopping Cart Integration',
        'Payment Module Integration (Visa, MC, Discover & AMEX)',
        'Easy Product Search',
        'Product Reviews',
        '5 Promotional Banners',
        'Mobile Responsive',
        'Social Media Integration (Facebook, Instagram & Twitter)',
        '6 Months Complimentary Website Maintenance',
        'Newsletter Subscription',
        'Unlimited Revisions',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 5,
      'name' => 'Elite',
      'url' => 'packages/elite-ecommerce',
      'discounted_price' => '5099',
      'price' => '6999',
      'features' => [
        'Unlimited Page Website',
        'Unique Pages And UI Design',
        'Complete Custom Development',
        'Newsfeed Integration',
        'Social Media Plugins Integration',
        'Advanced Ecommerce Marketplace Features',
        'Inventory Management',
        'CRM (Customer Relation Management System)',
        'Advanced Admin Features 2.0',
        'Advanced User Features',
        'Dashboard And Analytics',
        'Seller/Shipping Distribution',
        'Seller Profile Management',
        'User Profile Management',
        'General Configuration Features',
        'Revenue Models',
        'Featured Products',
        'Google Advertisements',
        'Flash Sales Module',
        'Loyalty Rewards Module',
        'Mobile Responsive',
        'Upto 40 Stock Images',
        '10 Unique Banner Designs',
        'JQuery Slider',
        'Search Engine Submission',
        'Free Google Friendly Sitemap',
        'Social Media Page Designs (Facebook, Twitter, Instagram)',
        'Complete W3C Certified HTML',
        'Complete Deployment',
        '100% Unique Design Assurance',
        'Complete Ownership Rights'
      ]
    ],
    [
      'id' => 6,
      'name' => 'Corporate',
      'url' => 'packages/corporate-ecommerce',
      'discounted_price' => '7699',
      'price' => '9398',
      'features' => [
        'Unlimited Page Website',
        'Custom Content Management System (CMS)',
        'Unique Pages And UI Design',
        'Complete Custom Development',
        'Process Automation Tools',
        'Newsfeed Integration',
        'Social Media Plugins Integration',
        'Upto 40 Stock Images',
        '10 Unique Banner Designs',
        'JQuery Slider',
        'Search Engine Submission',
        'Free Google Friendly Sitemap',
        'FREE 5 Years Hosting',
        'Custom Email Addresses',
        'Social Media Page Designs (Facebook, Twitter, Instagram)',
        'Complete W3C Certified HTML',
        'Complete Deployment',
        '100% Satisfaction Guarantee',
        '100% Unique Design Guarantee',
        'Money Back Guarantee',
        'Automated Inventory/Shipping/Supplier Module',
        'Manage Thousands To Millions Of Inventory With Ease And Check Stock Levels In Real-Time',
        'Receive Low Inventory Notifications And Generate Purchase Orders To Replenish Your Stock',
        'Suppliers Integration (API NEEDED)',
        'Shipper Integration (API NEEDED)',
        'Order Management',
        'LOT Numbers And Expire Date Tracking',
        'Receive Stock Into A Specific Warehouse (If Warehouse - API NEEDED)',
        'Fulfill Orders From A Particular Warehouse (If Warehouse - API NEEDED)',
        'Stock Management',
        'Actionable Insights',
        'Real-Time Visibility',
        'Inventory Opportunities',
        'Advanced Features: (API Needed For Suppliers/Warehouse)',
        'Speak To Suppliers During Trivial Conversations',
        'Set And Send Actions To Suppliers Regarding Governance And Compliance Materials',
        'Place Purchasing Requests',
        'Research And Answer Internal Questions Regarding Procurement Functionalities Or A Supplier/Supplier Set',
        'Receiving/Filing/Documentation Of Invoices And Payments/Order Requests',
        'Machine Learning (ML) For Supply Chain Planning (SCP)',
        'Machine Learning For Warehouse Management',
        'Natural Language Processing (NLP) For Data Cleansing And Building Data Robustness',
        'Automated Invoices & Estimates',
        'Automated Split Invoicing',
        'Automated Combine Invoices',
        'Invoice Templates',
        'Automated Barcode Scanning',
        'Locations And Zones',
        'Easily Track Where All Your Inventory Is By Organizing Everything Into Locations And Zones',
        'Organize Inventory Items Using Custom Attributes Such As Size, Color, And Location',
        'Customer Accounts',
        'Performance And Analytics',
        'Customization Of Personal Details',
        'Process Management',
        'Sales Automation',
        'Team Collaboration',
        'Marketing Automation',
        'Security',
        'Integrations',
        'Mobile Notifications',
        'Sales Reports',
        'Trend Analytics',
        'Forecasting',
        'Territory Management',
        'Account Management',
        'Event Integration',
        'Advanced Data Security',
        'Purchase Orders',
        'Backordering',
        'Financial Reports'
      ]
    ],
    [
      'id' => 7,
      'name' => 'Custom CRM/ERP',
      'url' => 'packages/custom-crm-erp',
      'discounted_price' => '11099',
      'price' => '13398',
      'features' => [
        'Unlimited Page Website',
        'Unique Pages And UI Design',
        'Complete Custom Development',
        'Newsfeed Integration',
        'CRM (Customer Relation Management System)',
        'Performance And Analytics',
        'Customization Of Personal Details',
        'Process Management',
        'Sales Automation',
        'Team Collaboration',
        'Marketing Automation',
        'Security',
        'Integrations',
        'Mobile Notifications',
        'Sales Reports',
        'Trend Analytics',
        'Forecasting',
        'Territory Management',
        'Account Management',
        'Event Integration',
        'Advanced Data Security',
        'Opportunity Management',
        'Sales Forecasting',
        'Call/Video Logging',
        'Quotes',
        'Contracts',
        'Document Library',
        'Case Management',
        'Analytics And Dashboards',
        'Lead Management',
        'Resource Management',
        'Analytics',
        'Web Intelligence',
        'Automated Emails, Invoices & Estimates',
        'Automated Split Invoicing',
        'Automated Combine Invoices',
        'Invoice Templates',
        'Financial Reports',
        'Generate Automated Sales Reports',
        'Core Modules',
        'Human Resources',
        'Integration',
        'Business Intelligence',
        'Sales/Marketing',
        'Finance',
        'Core Features',
        'Reporting',
        'Accounting',
        'Tracking And Visibility',
        'Centralized Modules',
        'ERP Database',
        'Human Resources Management',
        'Business Process Management',
        'Enterprise Analytics',
        'Business Intelligence',
        'ERP Database',
        'Integrations',
        'If (Manufacturing) (Optional)',
        'Accounting',
        'Distribution',
        'Business Intelligence',
        'Insights',
        'Standardization',
        'Procurement',
        'Reporting And Analytics',
        'Forecasting',
        'Projection',
        'Enterprise-Wide Integration',
        'Real-Time Operations',
        'Problem Definition',
        'Description Of The Programs Objectives And Scope',
        'Assumptions',
        'Implementation Costs',
        'Implementation Schedule',
        'Development And Operational Risks',
        'Projected Benefits',
        'Team Members',
        'Contracts',
        'Infrastructure Upgrades',
        'Create Work Plans And Timelines',
        'Analyze Gaps',
        'Configure Parameters',
        'Migrate Data',
        'Test System',
        'Document System',
        'Advanced Admin Features 2.0',
        'User Signup/Login Functionalities',
        'Advanced User Features',
        'User Profile Management',
        'General Configuration Features',
        'Complete W3C Certified HTML'
      ]
    ]
  ],
  'marketing_collateral' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-marketing-collateral',
      'discounted_price' => '99',
      'price' => '198',
      'features' => [
        '1 Stationery Design Set',
        'FREE Fax Template',
        'Print Ready Formats',
        'UNLIMITED Revisions',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Classic',
      'url' => 'packages/classic-marketing-collateral',
      'discounted_price' => '199',
      'price' => '788',
      'features' => [
        '2 Stationery Design Set',
        'UNLIMITED Revisions',
        'Flyer Design',
        'Brochure Design (Bi-Fold/Tri-Fold)',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Premium',
      'url' => 'packages/premium-marketing-collateral',
      'discounted_price' => '399',
      'price' => '1188',
      'features' => [
        '4 Stationery Design Set',
        'Packaging Design',
        'UNLIMITED Revisions',
        'T-Shirt Design',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Unlimited',
      'url' => 'packages/unlimited-marketing-collateral',
      'discounted_price' => '499',
      'price' => '1088',
      'features' => [
        '6 Stationery Design Set',
        'Menu Card Design',
        'T-Shirt Design',
        '1 Banner Design',
        '100% Satisfaction Guarantee',
        'Satisfaction Assurance'
      ]
    ]
  ],
  'motion_graphics' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-motion',
      'discounted_price' => '299',
      'price' => '499',
      'features' => [
        '15s Duration - HD 1080',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Classic',
      'url' => 'packages/classic-motion',
      'discounted_price' => '599',
      'price' => '998',
      'features' => [
        '30s Duration - HD 1080',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Premium',
      'url' => 'packages/premium-motion',
      'discounted_price' => '999',
      'price' => '1048',
      'features' => [
        '60 Second Video',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists',
        'Unlimited Revisions'
      ]
    ]
  ],
  'digital_marketing' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-digital-marketing',
      'discounted_price' => '99',
      'price' => '198',
      'features' => [
        'Cover Photo Design',
        'Profile Picture Design',
        'Welcome Page Design',
        'Unlimited Revisions',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Classic',
      'url' => 'packages/classic-digital-marketing',
      'discounted_price' => '149',
      'price' => '149', // No original price provided
      'features' => [
        'Cover Photo Design',
        'Profile Picture Design',
        'Welcome Page Design',
        'Twitter Page Design',
        'Unlimited Revisions',
        '100% Money Back Guarantee'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Premium',
      'url' => 'packages/premium-digital-marketing',
      'discounted_price' => '199',
      'price' => '398',
      'features' => [
        'Cover Photo Design',
        'Profile Picture Design',
        'Welcome Page Design',
        'Twitter Page Design',
        'YouTube Page Design',
        'Unlimited Revisions'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Unlimited',
      'url' => 'packages/unlimited-digital-marketing',
      'discounted_price' => '999',
      'price' => '1998',
      'features' => [
        '2 Cover Photo Designs',
        'Profile Picture Design',
        'Welcome Page Design',
        'Twitter Page Design',
        'YouTube Page Design',
        'Google+ Page Design'
      ]
    ]
  ],
  'social_media_marketing' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-social-media-marketing',
      'discounted_price' => '349',
      'price' => '699',
      'features' => [
        '2 Social Networks Included (Facebook, Instagram, Twitter)',
        '2 Posts Per Week',
        'Account Creation/Optimization',
        'Content Creation',
        'Create Cover & Profile Picture',
        'Account Monitoring & Engagement',
        'Monthly Progress Report'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Scaling',
      'url' => 'packages/scaling-social-media-marketing',
      'discounted_price' => '699',
      'price' => '1,399',
      'features' => [
        '3 Social Networks Included (Facebook, Instagram & Twitter)',
        '4 Postings Per Week',
        'Copywriting & Visual Designs',
        'Account Creation/Optimization',
        'Business Page Optimization',
        'Monthly Progress Report',
        'Reputation Management',
        'Social Account Setup',
        'Content Creation',
        'Social Media Hearing',
        'Query and Comments Reply'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Venture',
      'url' => 'packages/venture-social-media-marketing',
      'discounted_price' => '1,199',
      'price' => '2,399',
      'features' => [
        '5 Social Networks Included (Facebook, Instagram, Twitter, LinkedIn & YouTube)',
        '5 Postings Per Week',
        'Copywriting & Visual Designs',
        'Account Creation/Optimization',
        'Business Page Optimization',
        'Comprehensive Ad Campaign Management',
        'Spam Monitoring',
        'Detailed Analytic Reporting',
        'Social Media Hearing',
        'Brand Monitoring'
      ]
    ]
  ],
  'branding' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-branding',
      'discounted_price' => '99',
      'price' => '198',
      'features' => [
        '1 Stationery Design Set',
        'FREE Fax Template',
        'Print Ready Formats',
        'UNLIMITED Revisions',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Classic',
      'url' => 'packages/classic-branding',
      'discounted_price' => '199',
      'price' => '788',
      'features' => [
        '2 Stationery Design Set',
        'UNLIMITED Revisions',
        'Flyer Design',
        'Brochure Design (Bi-Fold/Tri-Fold)',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Premium',
      'url' => 'packages/premium-branding',
      'discounted_price' => '399',
      'price' => '1,188',
      'features' => [
        '4 Stationery Design Set',
        'Packaging Design',
        'UNLIMITED Revisions',
        'T-Shirt Design',
        'Satisfaction Assurance'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Unlimited',
      'url' => 'packages/unlimited-branding',
      'discounted_price' => '499',
      'price' => '1,088',
      'features' => [
        '6 Stationery Design Set',
        'Menu Card Design',
        'T-Shirt Design',
        '1 Banner Design',
        '100% Satisfaction Guarantee',
        'Satisfaction Assurance'
      ]
    ]
  ],
  'video' =>
  [
    [
      'id' => 1,
      'name' => 'Startup',
      'url' => 'packages/startup-video',
      'discounted_price' => '299',
      'price' => '499',
      'features' => [
        '15s Duration - HD 1080',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Classic',
      'url' => 'packages/classic-video',
      'discounted_price' => '599',
      'price' => '998',
      'features' => [
        '30s Duration - HD 1080',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Premium',
      'url' => 'packages/premium-video',
      'discounted_price' => '999',
      'price' => '1,048',
      'features' => [
        '60 Second Video',
        'Professional Script',
        'Storyboard Design',
        'Animations & VFX',
        'Music And Foley',
        'Voice Over Artists',
        'Unlimited Revisions'
      ]
    ]
  ],
  'combo' =>
  [
    [
      'id' => 1,
      'name' => 'Basic',
      'url' => 'packages/basic-combo',
      'discounted_price' => '229',
      'price' => '319',
      'features' => [
        'Logo Design',
        '5 Custom Logo Design Concepts',
        'By 2 Designers',
        'Icon Design',
        'All Final File Formats',
        'Business Stationery',
        'Business Card, Letterhead, Envelope, Fax Template',
        'MS Word Letterhead',
        'Website Design',
        '5 Page Website',
        'Mobile Responsive',
        'Team of Expert Designers & Developers',
        '8 Stock images',
        '5 Banner Designs',
        'jQuery Sliders',
        'Free Google Friendly Sitemap',
        'Facebook Page Design',
        'Complete W3C Certified HTML',
        'Complete Deployment',
        'Value Added Services',
        'Logo Design Final Files (.PNG, .JPG, .PDF)',
        'Website Design Complete Source Files',
        'Dedicated Project Manager',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
    [
      'id' => 2,
      'name' => 'Startup',
      'url' => 'packages/startup-combo',
      'discounted_price' => '994',
      'price' => '1,988',
      'features' => [
        'Logo Design',
        'Unlimited Logo Design Concepts',
        'Unlimited Revisions',
        'Icon Design',
        'All Final File Formats',
        'Stationary Design',
        'Business Card, Letterhead, Envelope',
        'MS Word Letterhead',
        'Website Design',
        'UNLIMITED Pages Website',
        'Content Management System (CMS)',
        'Mobile Responsive',
        '5 Stock Photos + 3 Banner Designs',
        'Any 3 Social Media Platforms',
        'Complete W3C Certified HTML',
        'Complete Deployment',
        'Value Added Services',
        'Dedicated Account Manager',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
    [
      'id' => 3,
      'name' => 'Professional',
      'url' => 'packages/professional-combo',
      'discounted_price' => '1,299',
      'price' => '2,599',
      'features' => [
        'Logo Design',
        'Unlimited Logo Concepts',
        '8 Dedicated Designers',
        'Icon Design',
        'Unlimited Revisions',
        'All file formats',
        'Print Materials',
        '2 Free Custom Stationary Designs',
        'MS Word Letterhead',
        'Free Trifold Brochure Design',
        'Website Design',
        'Unlimited Pages Design',
        'Conceptual and Dynamic Liquid Website',
        'Team of Expert Designers & Developers',
        'Word Press OR Custom Php',
        'Content Management System',
        'Mobile Responsive',
        'Online Reservation/Appointment Tool (Optional)',
        'Custom Forms',
        'Lead Capturing Forms (Optional)',
        'Newsfeed Integration',
        'Social Media Integration',
        'Search Engine Submission',
        '15 Stock images',
        '8 Unique Banner Designs',
        'jQuery Sliders',
        'Free Google Friendly Sitemap',
        'Complete W3C Certified HTML',
        'Social Media Page Design',
        'Facebook Page Design',
        'Twitter Page Design',
        'YouTube Page Design',
        'Google+ Page Design',
        'Value Added Services',
        'Dedicated Account Manager',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
    [
      'id' => 4,
      'name' => 'Identity',
      'url' => 'packages/identity-combo',
      'discounted_price' => '1,899',
      'price' => '3,300',
      'features' => [
        'Logo Design',
        '9 Logo Design Idea(s)',
        'By 4 Expert Level Designer(s)',
        'Free Icon Design',
        'Unlimited Revisions',
        '2 to 3 Business Days TAT',
        'Stationary Design',
        'Letterhead Design',
        'Business Card Design',
        'Envelope Design',
        'Email Signature Design',
        'Electronic Letterhead',
        'Invoice Design',
        'Website Design',
        'Unique 5 Pages Website Design',
        'Custom, Interactive, Dynamic & High End Web Design',
        'Custom WordPress Development',
        '5 Stock Images',
        '5 Banner Designs',
        'Sliding Banners',
        'Unlimited Revisions',
        'Special Hoover Effects',
        'Content Management System (WordPress)',
        'Mobile Responsive',
        'Online Appointment/Booking/Scheduling/Online Ordering Integration (If Required)',
        'FREE 12 Months Domain Name',
        'FREE 12 Month Hosting',
        '5 Professional Email ID’s',
        'Social Media Page Integration',
        'Google Friendly Sitemap',
        'Search Engine Submission',
        'Complete W3C Certified HTML',
        'Industry specified Team of Expert Designers and Developers',
        'Complete Deployment',
        'Social Media Page Design',
        'Facebook Icon Image & Banner Design',
        'Twitter Icon Image & Banner Design',
        'Google+ Icon Image & Banner Design',
        'Value Added Services',
        'Logo Design Final Files (.AI, .PSD, .EPS, .PNG, .JPG, .PDF, .TIFF)',
        'Website Design Complete Source Files',
        'Dedicated Project Manager',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*',
        'Add on',
        'Professional Content/Copywriting',
        'Online Payment Integration',
        'Shopping Cart Integration',
        'Additional Professional Email ID'
      ]
    ],
    [
      'id' => 5,
      'name' => 'Corporate',
      'url' => 'packages/corporate-combo',
      'discounted_price' => '2,899',
      'price' => '3,800',
      'features' => [
        'Logo Design',
        'Unlimited Logo Design Idea(s)',
        '8 Dedicated Designers',
        'Icon Design',
        'All Final File Formats',
        'Stationary Design',
        '2 Free Custom Stationary Designs',
        'MS Word Letterhead',
        'Invoice Design',
        'FREE Tri fold Brochure Design',
        'Website Design',
        'Unlimited Pages Website',
        'Conceptual and Dynamic Website',
        'Word Press OR CUSTOM PHP',
        'Content Management System (CMS)',
        'Easy Product Search',
        'Product Reviews',
        'Unlimited Products',
        'Unlimited Categories',
        'Promotional Product Showcase',
        'New Product Showcase',
        'Full Shopping Cart Integration',
        'Payment Module Integration',
        'Sales & Inventory Management',
        'Custom Forms',
        'Lead Capturing Forms (Optional)',
        'Newsfeed Integration',
        'Social Media Integration',
        'Search Engine Submission',
        'Team of Dedicated Designers, Developers and Brand Experts',
        '20 Stock images',
        '6 Unique Banner Designs',
        'jQuery Slider',
        'Free Google Friendly Sitemap',
        'Complete W3C Certified HTML',
        'Social Media Page Design',
        'Facebook Page Design',
        'Twitter Page Design',
        'YouTube Page Design',
        'Google+ Page Design',
        'Pinterest Page Design',
        'Value Added Services',
        'Dedicated Account Manager',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
    [
      'id' => 6,
      'name' => 'Elite',
      'url' => 'packages/elite-combo',
      'discounted_price' => '5,499',
      'price' => '8,999',
      'features' => [
        'Logo Design',
        'Unlimited Logo Design Idea(s)',
        '8 Dedicated Designers',
        'Icon Design',
        'All final file formats',
        'Stationary Design',
        '2 Free Custom Stationary Designs',
        'MS Word Letterhead',
        'Invoice Design',
        'Free Trifold Brochure Design',
        'Website Design',
        'Complete Custom Design & Development',
        'Any One: Dating Portal, Job Portal, Professional Network, Social Network, Medical Portal, Restaurant Portal, Medical Portal, News Portal, Enterprise Portal',
        'Unique, User Friendly, Interactive, Dynamic, High End UI Design',
        'Unlimited Banner Designs',
        'JQuery Slider',
        'Special Hoover Effects',
        '20 Stock Images',
        'Client/User Dashboard Area',
        'Custom Coding',
        'Custom PHP Development',
        'Content Management System (Custom)',
        'Online Appointment/Scheduling/Online Ordering Integration (Optional)',
        'Online Payment Integration (Optional)',
        'Multi-Lingual (Optional)',
        'Custom Dynamic Forms (Optional)',
        'User Signup Area',
        'User Login Area',
        'User Dashboard Area',
        'Complete Database Creation',
        'Signup Automated Email Authentication',
        'Web Traffic Analytics Integration',
        '3rd Party API Integrations',
        'Signup Area (For Newsletters, Offers etc.)',
        'Search Bar for Easy Search',
        'Live Feeds of Social Networks integration (Optional)',
        'Search Engine Submission',
        'Module-wise Architecture',
        'Extensive Admin Panel',
        'Award Winning Team of Expert Designers and Developers',
        'Complete Deployment',
        'Value Added Services',
        'Dedicated Account Manager',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
    [
      'id' => 7,
      'name' => 'Ultimate',
      'url' => 'packages/ultimate-combo',
      'discounted_price' => '6,999',
      'price' => '10,000',
      'features' => [
        'Logo Design',
        'Unlimited Logo Design Idea(s)',
        'Unlimited Revisions',
        'Icon Design',
        'All Final File Formats',
        'Stationary Design',
        '2 Free Custom Stationary Designs',
        'MS Word Letterhead',
        'Invoice Design',
        'Free Trifold Brochure Design',
        'Website Design',
        'Complete Custom Design & Development',
        'Unique, User Friendly, Interactive, Dynamic, High End UI Design',
        'Unlimited Banner Designs',
        'Client/User Dashboard Area',
        'Custom Coding',
        'Custom PHP Development',
        'Content Management System (Custom)',
        'Online Appointment/Scheduling/Online Ordering Integration (Optional)',
        'Online Payment Integration (Optional)',
        'Multi-Lingual (Optional)',
        'Custom Dynamic Forms (Optional)',
        'User Signup Area',
        'User Login Area',
        'User Dashboard Area',
        'Complete Database Creation',
        'Signup Automated Email Authentication',
        'Web Traffic Analytics Integration',
        '3rd Party API Integrations',
        'Search Engine Submission',
        'Module-wise Architecture',
        'Extensive Admin Panel',
        'Award Winning Team of Expert Designers and Developers',
        'Complete Deployment',
        'Value Added Services',
        'Dedicated Account Manager',
        '100% Satisfaction Guarantee',
        '100% Money Back Guarantee',
        '*NO MONTHLY OR ANY HIDDEN FEE*'
      ]
    ],
  ],
];

$packageTypes = [
  'logo_design' => [
    1 => '',
    2 => 'best',
    3 => 'orange',
    4 => ''
  ],
  'website_design' => [
    1 => '',
    2 => 'best',
  ],
];
