<?php
include_once '../pricing_data.php';

$pkgURL = 'packages/' . basename($_SERVER['REQUEST_URI']);

$pkg = null;
$pkgCategory = null;
foreach ($pricingPackages as $category => $packages) {
  $pkgCategory = explode('_', $category)[0];
  foreach ($packages as $p) {
    if ($p['url'] === $pkgURL) {
      $pkg = $p;
      break 2;
    }
  }
}

if ($pkg === null) {
  echo "Package not found.";
}
?>
<!-- HEAD TAG -->
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- ========== Meta Tags ========== -->
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="Avrix - Digital Agency Portfolio Template">

  <!-- ========== Page Title ========== -->
  <title>Savvy Design Hub</title>

  <!-- ========== Favicon Icon ========== -->
  <link rel="apple-touch-icon" sizes="180x180" href="../assets/img/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="../assets/img/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="../assets/img/favicon/favicon-16x16.png">
  <link rel="manifest" href="../assets/img/favicon/site.webmanifest">
  <meta name="msapplication-TileColor" content="#da532c">
  <meta name="theme-color" content="#ffffff">

  <!-- ========== Start Stylesheet ========== -->
  <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="../assets/css/font-awesome.min.css" rel="stylesheet">
  <link href="../assets/css/magnific-popup.css" rel="stylesheet">
  <link href="../assets/css/flaticon-set.css" rel="stylesheet">
  <link href="../assets/css/swiper-bundle.min.css" rel="stylesheet">
  <link href="../assets/css/animate.min.css" rel="stylesheet">
  <link href="../assets/css/validnavs.css" rel="stylesheet">
  <link href="../assets/css/helper.css" rel="stylesheet">
  <link href="../assets/css/unit-test.css" rel="stylesheet">
  <link href="../assets/css/style.css" rel="stylesheet">
  <!-- ========== End Stylesheet ========== -->
</head>

<body class="bg-dark">
  <?php include '../components/preloader.php'; ?>

  <?php
  $activePage = substr($_SERVER['SCRIPT_NAME'], strrpos($_SERVER['SCRIPT_NAME'], "/") + 1);
  include("../services_content.php");
  ?>
  <header class="overflow-hidden">
    <!-- Start Navigation -->
    <nav class="navbar mobile-sidenav navbar-sticky navbar-default validnavs navbar-fixed no-background">
      <div class="container-fluid px-5 d-flex justify-content-between align-items-center">
        <!-- Start Header Navigation -->
        <div class="navbar-header">
          <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
            <i class="fa fa-bars"></i>
          </button>
          <a class="navbar-brand" href="index.html">
            <img id="navLogo" src="../assets/img/logo/04.png" class="logo" alt="Logo">
          </a>
        </div>
        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse" id="navbar-menu">

          <img id="navLogo" src="../assets/img/logo/06.png" alt="Logo">
          <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
            <i class="fa fa-times"></i>
          </button>

          <ul class="nav navbar-nav navbar-center" data-in="fadeInDown" data-out="fadeOutUp">
            <li>
              <a href="../index.php" class="<?= $activePage == 'index.php' ? 'active' : ''; ?>">Home</a>
            </li>
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">Services</a>
              <ul class="dropdown-menu">
                <div class="row mx-0">
                  <div class="col-lg-9 p-0">
                    <div class="dropdown_left">
                      <div class="row mx-0">
                        <?php foreach ($services as $service) : ?>
                          <div class="col-lg-4 px-1 my-1">
                            <a href="../<?= $service['link']; ?>" class="d-flex dropdown-item">
                              <img src="../assets/img/icon/<?= $service['nav_icon']; ?>" alt="">
                              <div class="drop_text">
                                <h4><?= $service['title']; ?></h4>
                                <p><?= $service['nav_text']; ?></p>
                              </div>
                            </a>
                          </div>
                        <?php endforeach; ?>
                      </div>
                    </div>
                    <hr class="dropdown-hr">
                  </div>
                  <div class="col-lg-3 p-0">
                    <div class="dropdown_right"></div>
                  </div>
                  <div class="col-12">
                    <div class="dropdown_footer">
                      <div class="df_text">
                        <h3>Want to know if Savvy Design Hub is a good fit?</h3>
                        <p>
                          Book a quick demo and let us answer all your questions!
                        </p>
                      </div>
                      <form action="">
                        <input type="email" class="form-control" placeholder="Your Email">
                        <i class="fa fa-envelope"></i>
                        <a type="submit" class="btn btn-dark">Get Started</a>
                      </form>
                    </div>
                  </div>
                </div>
              </ul>
            </li>
            <li><a href="../portfolio.php" class="<?= $activePage == 'portfolio.php' ? 'active' : ''; ?>">Portfolio</a>
            </li>
            <li><a href="../pricing.php" class="<?= $activePage == 'pricing.php' ? 'active' : ''; ?>">Pricing</a></li>
            <li><a href="../about-us.php" class="<?= $activePage == 'about-us.php' ? 'active' : ''; ?>">About Us</a>
            </li>
          </ul>
        </div><!-- /.navbar-collapse -->

        <div class="attr-right d-flex align-items-center justify-content-between">
          <a href="../contact.php" class="btn btn-nav-r">contact <span><img src="../assets/img/icon/arrow-up.png"
                alt=""></span></a>
          <!-- Start Atribute Navigation -->
          <div class="attr-nav flex">
            <ul>
              <li class="side-menu">
                <a href="#">
                  <span class="bar-1"></span>
                  <span class="bar-2"></span>
                  <span class="bar-3"></span>
                </a>
              </li>
            </ul>
          </div>
          <!-- End Atribute Navigation -->


          <!-- Start Side Menu -->
          <div class="side">
            <a href="#" class="close-side"><i class="fas fa-times"></i></a>
            <div class="widget">
              <div class="logo">
                <img src="../assets/img/logo/04.png" alt="Logo">
              </div>
            </div>
            <div class="widget">
              <p>
                Digital marketing is the component of marketing that uses the Internet and online based digital
                technologies such as desktop computers, mobile phones and other digital media and platforms to promote
                products and services.
              </p>
            </div>
            <div class="widget address">
              <div>
                <ul>
                  <li>
                    <div class="content">
                      <p>Address</p>
                      <strong>California, TX 70240</strong>
                    </div>
                  </li>
                  <li>
                    <div class="content">
                      <p>Email</p>
                      <strong>info@savvydesignhub.com</strong>
                    </div>
                  </li>
                  <li>
                    <div class="content">
                      <p>Contact</p>
                      <strong>+44-20-7328-4499</strong>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <div class="widget newsletter">
              <h4 class="title">Get Subscribed!</h4>
              <form action="#">
                <div class="input-group stylish-input-group">
                  <input type="email" placeholder="Enter your e-mail" class="form-control" name="email">
                  <span class="input-group-addon">
                    <button type="submit">
                      <i class="fas fa-arrow-right"></i>
                    </button>
                  </span>
                </div>
              </form>
            </div>
            <div class="widget social">
              <ul class="link">
                <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                <li><a href="#"><i class="fab fa-behance"></i></a></li>
              </ul>
            </div>

          </div>
          <!-- End Side Menu -->

        </div>
        <!-- Main Nav -->

      </div>
      <!-- Overlay screen for menu -->
      <div class="overlay-screen"></div>
      <!-- End Overlay screen for menu -->
    </nav>
    <!-- End Navigation -->
  </header>
  <section class="pkg_sec">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-9">
          <div class="pkg_content">
            <h1 class="title"><?= $pkg['name'] . ' ' . $pkgCategory; ?> Package</h1>
            <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Sapiente, quasi quam consequuntur porro tenetur
              accusantium?</p>
          </div>
        </div>
      </div>
      <div class="row mt-70">
        <div class="col-12 col-lg-5">
          <div class="pkg-left">
            <div class="pkg-detail">
              <h3 class="title"><?= $pkg['name']; ?> package</h3>
              <h5 class="price-h">
                <i class="far fa-dollar-sign"></i>
                <?= number_format((float) $pkg['discounted_price'], 2, '.', '') ?>
              </h5>
              <p>Lorem ipsum dolor sit, amet consectetur adipisicing elit. Ipsum, ad!</p>
              <a href="#" class="btn btn-gradient btn-sm">Place Your Order</a>
            </div>
            <hr>
            <div class="pkg-footer">
              <a href="#" class="me-4"><i class="fas fa-comments-alt-dollar me-2"></i>live chat</a>
              <a href="#">+44-121-468-0105</a>
            </div>
          </div>
        </div>
        <div class="col-12 col-lg-7">
          <div class="pkg-right">
            <h3 class="title"><?= $pkg['name']; ?> Package</h3>
            <ul>
              <?php foreach ($pkg['features'] as $feature) { ?>
                <li><?= $feature ?></li>
              <?php } ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>
  <footer>
    <div class="footer-box">
      <div class="container">
        <div class="f-items default-padding-bottom pt-70 pt-xs-0">
          <div class="row">
            <!-- Singel Item -->
            <div class="col-lg-3 col-md-6 footer-item mt-50">
              <div class="f-item about pr-50 pr-xs-0 pr-md-0">
                <img class="logo" src="../assets/img/logo/<?= empty($logo) ? '01.png' : $logo; ?>" alt=" Logo">
                <p class="me-2">
                  innovative and customer-centric approach will transform your brand. Raise your company’s development
                  and
                  success with our inventive design solutions.
                </p>
                <div class="footer-social mt-30">
                  <ul>
                    <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                    <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                    <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                  </ul>
                </div>
              </div>
            </div>
            <!-- End Singel Item -->

            <!-- Singel Item -->
            <div class="col-lg-3 col-md-6 mt-50 footer-item pl-50 pl-md-15 pl-xs-15">
              <div class="f-item link">
                <h4 class="widget-title">Company</h4>
                <ul>
                  <li>
                    <a href="../about-us.php">About</a>
                  </li>
                  <li>
                    <a href="../contact-us.php">Help Center</a>
                  </li>
                  <li>
                    <a href="../portfolio.php">Portfolio</a>
                  </li>
                  <li>
                    <a href="../pricing.php">Pricing</a>
                  </li>
                </ul>
              </div>
            </div>
            <!-- End Singel Item -->

            <!-- Singel Item -->
            <div class="col-lg-3 col-md-6 footer-item  mt-50">
              <div class="f-item contact">
                <h4 class="widget-title">Contact Info</h4>
                <ul>
                  <li>
                    <div class="content">
                      <strong>Address:</strong>
                      5919 Trussville Crossings Pkwy, Birmingham
                    </div>
                  </li>
                  <li>
                    <div class="content">
                      <strong>Email:</strong>
                      <a href="mailto:info$savvydesignhub.com">info$savvydesignhub.com</a>
                    </div>
                  </li>
                  <li>
                    <div class="content">
                      <strong>Phone:</strong>
                      <a href="tel:2151234567">+123 34598768</a>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <!-- End Singel Item -->

            <!-- Singel Item -->
            <div class="col-lg-3 col-md-6 footer-item mt-50">
              <div class="f-item newsletter">
                <h4 class="widget-title">Newsletter</h4>
                <p>
                  Join our subscribers list to get the instant latest news and special offers.
                </p>
                <form action="#">
                  <input type="email" placeholder="Your Email" class="form-control" name="email">
                  <button type="submit"><i class="fas fa-arrow-right"></i></button>
                </form>
              </div>
            </div>
            <!-- End Singel Item -->


          </div>
        </div>
      </div>

      <!-- Footer Bottom -->
      <div class="footer-bottom bg-dark text-light text-center">
        <div class="container">
          <div class="row">
            <div class="col-lg-9 offset-lg-3">
              <p>
                Copyright &copy; <?= date('Y'); ?> Savvy Design Hub. All Rights Reserved
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- End Footer Bottom -->
    </div>
  </footer>
  <script src="../assets/js/jquery-3.6.0.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/jquery.appear.js"></script>
  <script src="../assets/js/swiper-bundle.min.js"></script>
  <script src="../assets/js/progress-bar.min.js"></script>
  <script src="../assets/js/circle-progress.js"></script>
  <script src="../assets/js/isotope.pkgd.min.js"></script>
  <script src="../assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="../assets/js/magnific-popup.min.js"></script>
  <script src="../assets/js/count-to.js"></script>
  <script src="../assets/js/jquery.scrolla.min.js"></script>
  <script src="../assets/js/ScrollOnReveal.js"></script>
  <script src="../assets/js/YTPlayer.min.js"></script>
  <script src="../assets/js/validnavs.js"></script>
  <script src="../assets/js/gsap.js"></script>
  <script src="../assets/js/gsap_anim.js"></script>
  <script src="../assets/js/ScrollTrigger.min.js"></script>
  <script src="../assets/js/horizontal-scroll.js"></script>
  <script src="../assets/js/main.js"></script>


  <script>
    $(document).ready(function() {
      // Get all filter buttons and portfolio items
      const $filterButtons = $('.works_navbar li a');
      const $portfolioItems = $('.work_item');

      // Filter function to show/hide items based on category
      function filterItems(category) {
        $portfolioItems.each(function() {
          const $item = $(this);
          const itemCategory = $item.data('category');
          if (category === 'all' || itemCategory === category) {
            $item.show();
            // Add 'active' class to the clicked button
            $filterButtons.removeClass('active');
            $(this).parent().addClass('active');
          } else {
            $item.hide();
          }
        });
      }

      // Initially show only the first 6 items if not on portfolio page
      <?php if ($current_page !== 'portfolio'): ?>
        $portfolioItems.each(function(index) {
          $(this).toggle(index < 6);
        });
      <?php endif; ?>

      // Add event listeners to filter buttons
      $filterButtons.on('click', function() {
        const category = $(this).data('filter');
        filterItems(category);

        // Scroll smoothly down slightly from the current scroll position
        $('html, body').animate({
          scrollTop: $(window).scrollTop() + 50 // Adjust this value as needed
        }, 0); // Duration of the scroll in milliseconds
      });
    });
  </script>

  <script>
    document.querySelectorAll('.thumb-zoom').forEach(item => {
      const video = item.querySelector('video');

      item.addEventListener('mouseenter', () => {
        video.currentTime = 0; // Start video from the beginning
        video.play(); // Play video
      });

      item.addEventListener('mouseleave', () => {
        video.pause(); // Pause video when hover is removed
        video.currentTime = 0; // Reset video to the start
      });
    });
  </script>

  <script>
    const labels = document.querySelectorAll('.label');

    labels.forEach(label => {
      // Get the text from each label
      const labelText = label.textContent;

      // Clear the original label text
      label.textContent = '';

      // Split the text into words
      const words = labelText.split(' ');

      words.forEach((word, wordIndex) => {
        // Loop through each character of the word
        word.split('').forEach((char, index) => {
          const span = document.createElement('span');
          span.textContent = char;
          span.classList.add('label-char');
          span.style.setProperty('--index', index); // Set the dynamic index as a custom property
          label.appendChild(span);
        });

        // Add a non-breaking space (&nbsp;) after each word, except the last one
        if (wordIndex < words.length - 1) {
          const nbspSpan = document.createElement('span');
          nbspSpan.innerHTML = '&nbsp;'; // Use a span to add a non-breaking space
          nbspSpan.classList.add('label-char');
          label.appendChild(nbspSpan);
        }
      });
    });
  </script>

  <script>
    $(document).ready(function() {
      const $filterButtons = $('.filternav');
      const $portfolioItems = $('.filterCategory');

      // Default filter: Display only logo design packages on page load
      filterItems('logo_design');

      // Filter function to show/hide items based on category
      function filterItems(category) {
        $portfolioItems.each(function() {
          const $item = $(this);
          const itemCategory = $item.data('category');

          if (itemCategory === category) {
            $item.show();
          } else {
            $item.hide();
          }
        });
        // Add 'active' class to the clicked button
        $filterButtons.removeClass('active');
        $(`[data-filter="${category}"]`).addClass('active');
      }

      // Event listeners for filter buttons
      $filterButtons.on('click', function() {
        const category = $(this).data('filter');
        filterItems(category);

        // Scroll down slightly from the current scroll position
        $('html, body').animate({
          scrollTop: $(window).scrollTop() + 50
        }, 0);
      });
    });
  </script>

</body>

</html>
