<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/phpmailer/phpmailer/src/Exception.php';
require '../vendor/phpmailer/phpmailer/src/PHPMailer.php';
require '../vendor/phpmailer/phpmailer/src/SMTP.php';

require '../vendor/autoload.php';
function getUserIP()
{
  if (array_key_exists('HTTP_X_FORWARDED_FOR', $_SERVER) && !empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
      $ip_addresses = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
      return trim($ip_addresses[0]);
    } else {
      return $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
  } else {
    return $_SERVER['REMOTE_ADDR'];
  }
}

function getIPInfo($ip)
{
  $ch = curl_init();

  curl_setopt($ch, CURLOPT_URL, "https://ipinfo.io/$ip/json");
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Skip SSL certificate verification if necessary

  $output = curl_exec($ch);

  if ($output === false) {
    return [
      'ip' => $ip,
      'city' => 'Unknown',
      'region' => 'Unknown',
      'country' => 'Unknown',
      'loc' => 'Unknown',
      'org' => 'Unknown',
    ];
  }

  curl_close($ch);

  // Decode the JSON response
  $ip_info = json_decode($output, true);

  // Return IP information
  return $ip_info;
}

$user_ip = getUserIP();
$ip_info = getIPInfo($user_ip);

$ip = $ip_info['ip'];
$city = $ip_info['city'];
$region = $ip_info['region'];
$country = $ip_info['country'];
$location = $ip_info['loc'];
$organization = $ip_info['org'];

$referrer = $_SERVER['HTTP_REFERER'];

if (isset($_POST['submit_btn'])) {
  $mail = new PHPMailer(true);

  $name = $_POST['name'];
  $email = $_POST['email'];
  $phone = $_POST['phone'];
  $message = $_POST['message'];

  $mail->isSMTP();
  $mail->Host = 'smtp.gmail.com';
  $mail->SMTPAuth = true;
  $mail->Username = 'adnankaka.786110@gmail.com';
  $mail->Password = 'ygje qbfh vfjs mcsk';
  $mail->SMTPSecure = 'tls';
  $mail->Port = 587;

  $mail->setFrom($email);

  $mail->addAddress('info@savvydesignhub.com');

  $mail->isHTML(true);

  $mail->Subject = 'Sign Up Form';

  $mail->Body =
    'Name: ' . $name . '<br>' .
    'Email: ' . $email . '<br>' .
    'Phone: ' . $phone . '<br>' .
    'Message: ' . $message . '<br>' .
    'IP Address: ' . $user_ip . '<br>' .
    'City: ' . $city . '<br>' .
    'Region: ' . $region . '<br>' .
    'Country: ' . $country . '<br>' .
    'Organization: ' . $organization . '<br>' .
    'Referrer Page: ' . $referrer;

  $mail->AltBody =
    'Name: ' . $name . '\n' .
    'Email: ' . $email . '\n' .
    'Phone: ' . $phone . '\n' .
    'Message: ' . $message . '\n' .
    'IP Address: ' . $user_ip . '<br>' .
    'City: ' . $city . '<br>' .
    'Region: ' . $region . '<br>' .
    'Country: ' . $country . '<br>' .
    'Organization: ' . $organization . '<br>' .
    'Referrer Page: ' . $referrer;

  if ($mail->send()) {
    header("location: https://savvydesignhub.com/thankyou");
  } else {
    header("location: https://savvydesignhub.com");
    echo '
        <script>
            alert("Message could not be sent. Mailer Error: ' . $mail->ErrorInfo . '")
        </script>
        ';
  }
} else {
  header("location: https://savvydesignhub.com");
  echo '
        <script>
            alert("Please fill out all places. Mailer Error: ' . $mail->ErrorInfo . '")
        </script>
        ';
}
