<?php include "./components/head.php"; ?>

<body class="bg-dark">

  <?php include "./components/preloader.php"; ?>

  <?php include "./components/navbar.php"; ?>

  <!-- Hero Banner -->
  <?php include './components/hero-sec.php'; ?>

  <!-- Background Move -->
  <div class="banner-animation-zoom position-relative">
    <div class="video-wrap">
      <video muted autoplay loop class="custom-video" style="filter: brightness(100%); max-width: 60%;">
        <source src="assets/videos/hero-1.mp4" type="video/mp4">
        "Your browser does not support the video tag."
      </video>
    </div>
    <div class="container">
      <div class="row">
        <div class="col-lg-6">
          <div class="experience-box">
            <div class="inner-content">
              <h2><strong>13+</strong> Years of experience</h2>
              <p>
                At Savy Design Hub, our years of experience have taught us that the simplest solutions often arise when
                our expertise is unleashed upon the data, transforming complexity into clarity.
              </p>
              <a class="btn-animation" href="services"><i class="fas fa-arrow-right"></i> <span>Our
                  Services</span></a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Services -->
  <div class="creative-services-area overflow-hidden default-padding">

    <div class="bg-static">
      <img class="bg-move" src="assets/img/shape/5.png" alt="Image Not Found">
    </div>

    <div class="container">
      <div class="row">
        <div class="col-lg-8">
          <div class="site-heading" data-gsap="fromOpacityScale">
            <h4 class="sub-title">Services We Offer</h4>
            <h2 class="title">Transform Data <br> into Powerful Insights</h2>
          </div>
        </div>
      </div>
    </div>

    <div class="container container-stage">
      <div class="row">
        <div class="col-lg-12">

          <div class="services-item-one-items">
            <!-- Navigation -->
            <div class="services-nav">
              <div class="nav-items">
                <div class="services-button-prev"></div>
                <div class="services-button-next"></div>
              </div>
            </div>
            <div class="services-carousel swiper">
              <!-- Additional required wrapper -->
              <div class="swiper-wrapper">
                <?php
                $count = 1;
                foreach ($services as $service):
                ?>
                  <!-- Single Item -->
                  <div class="swiper-slide">
                    <div class="cteative-service-item">
                      <img src="assets/img/icon/<?= $service['icon'] ?>" alt="Icon">
                      <h4><a href="<?= $service['link'] ?>">
                          <?= $service['title'] ?>
                        </a></h4>
                      <p>
                        <?= $service['description'] ?>
                      </p>
                      <span><?= $count++ ?></span>
                    </div>
                  </div>
                  <!-- End Single Item -->
                <?php endforeach; ?>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include("./components/about-box.php"); ?>

  <?php include("./components/works.php"); ?>


  <?php $class = "bg-gray";
  include("./components/fun-factor.php"); ?>

  <?php include("./components/why-us.php"); ?>

  <?php include("./components/testimonials.php"); ?>

  <!-- Slide Section -->
  <div class="multi-section overflow-hidden bg-dark-secondary text-light">

    <div class="thecontainer">

      <!-- Single Section -->
      <div class="panel overflow-hidden">
        <div class="container overflow-hidden">
          <div class="row align-center">
            <div class="col-lg-4">
              <div class="site-title" data-gsap="fromOpacityScale">
                <h4 class="sub-title">Award & Achivement </h4>
                <h2 class="title">Awards & Recognitions</h2>
              </div>
            </div>
            <div class="col-lg-7 offset-lg-1">
              <div class="achivement-items">
                <div class="achivement-grid">
                  <div class="achivement-item">
                    <img src="assets/img/logo/trustpilot.svg" alt="">
                  </div>
                  <div class="achivement-item">
                    <img src="assets/img/logo/clutch.svg" alt="">
                  </div>
                </div>
                <div class="achivement-grid">
                  <div class="achivement-item">
                    <img src="assets/img/logo/Bark.png" alt="">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- End Single Section -->

      <!-- Single Section -->
      <div class="panel contact-panel overflow-hidden">
        <div class="contact-panel-bg" style="background-image: url(assets/img/slider-h.jpg);"></div>
        <div class="container overflow-hidden">
          <div class="row">
            <div class="col-lg-6">
              <h4 class="sub-title">Have you project in mind?</h4>
              <h2 class="title">For instant support please reach us</h2>
              <a class="btn-round-animation dark mt-40" href="contact-us.html">Send Mail <i
                  class="fas fa-arrow-right"></i></a>
            </div>
          </div>
        </div>
      </div>
      <!-- End Single Section -->

    </div>
  </div>

  <?php include("./components/footer.php"); ?>

  <?php include("./components/js-scripts.php"); ?>
