<?php

$current_page = basename($_SERVER['PHP_SELF'], '.php');

$portfolio_items = [
  [
    "category" => "logo",
    "title" => "Photo shooting and editing",
    "image" => "assets/img/portfolio/p1.jpg",
    "video" => "",
    "link" => "project-details.html"
  ],
  [
    "category" => "web",
    "title" => "Quality in industrial design",
    "image" => "assets/img/portfolio/p8.jpg",
    "video" => "assets/videos/web_1.mp4",
    "link" => "project-details.html"
  ],
  [
    "category" => "illustration",
    "title" => "Quality in industrial design",
    "image" => "assets/img/portfolio/p7.jpg",
    "video" => "",
    "link" => "project-details.html"
  ],
  [
    "category" => "app",
    "title" => "Blue business mockup cards",
    "image" => "assets/img/portfolio/p6.jpg",
    "video" => "assets/videos/app_2.mp4",
    "link" => "project-details.html"
  ],
  [
    "category" => "app",
    "title" => "Simple black & white design",
    "image" => "assets/img/portfolio/p3.jpg",
    "video" => "assets/videos/app_1.mp4",
    "link" => "project-details.html"
  ],
  [
    "category" => "motion",
    "title" => "Simple black & white design",
    "image" => "assets/img/portfolio/p4.jpg",
    "video" => "assets/videos/mg_1.mp4",
    "link" => "project-details.html"
  ],
  [
    "category" => "logo",
    "title" => "Simple black & white design",
    "image" => "assets/img/portfolio/p2.jpg",
    "video" => "",
    "link" => "project-details.html"
  ]
];

// List of animations to cycle through
$animations = ["fadeInUp", "fadeInDown", "fadeInLeft", "fadeInRight"];
?>

<style>
  .works_navbar {
    display: flex;
    flex-wrap: wrap;
    justify-content: end;
  }

  .works_navbar li a {
    position: relative;
    display: block;
    z-index: 9;
    color: #fff;
    background-color: #004dff39;
    text-transform: uppercase;
    font-size: 12px;
    font-weight: 600;
    padding: 10px 18px;
    height: 42px;
    line-height: 25px;
    margin-left: 10px;
  }

  .works_navbar .refresh {
    font-size: 18px;
    padding: 4px 10px;
    line-height: 35px;
  }

  .works_navbar li a:where(:hover, :focus, .active) {
    background-color: #004dff;
  }

  .work_zoom.thumb-zoom {
    max-height: 450px;
  }

  .work_zoom.thumb-zoom video {
    display: none;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
  }

  .work_zoom.thumb-zoom:hover video {
    display: block;
    z-index: 2;
  }

  a.pf-btn {
    position: relative;
    z-index: 3;
  }

  .pf-item-info .content-info h2 {
    font-size: 25px;
    display: inline-block;
    max-width: 75%;
  }

  .work_item .pf-item-info {
    padding-left: 0;
    margin-top: 10px;
  }

  .default-hidden {
    display: none;
  }
</style>

<div class="portfolio-style-one-area default-padding bg-gray">

  <div class="container">
    <div class="heading-left mb-5">
      <div class="row align-items-center">
        <div class="<?= !$current_page == 'portfolio' ? 'col-lg-6' : 'col-lg-7' ?>">
          <div class="content-left" <?= !$current_page == 'portfolio' ? 'data-gsap="fromOpacityScale"' : '' ?>>
            <h4 class="sub-title"><?= !$current_page == 'portfolio' ? 'Popular' : 'Our' ?> Projects</h4>
            <h2 class="title">Discover the Solutions That Inspire</h2>
          </div>
        </div>
        <div class="col-lg-5 <?= !$current_page == 'portfolio' ? 'offset-lg-1' : '' ?> ">
          <p <?= !$current_page == 'portfolio' ? 'data-gsap="fromOpacityScale"' : '' ?>>
            Take a tour through our varied portfolio to see the variety of projects we’ve completed. Each creation,
            from appealing websites to memorable logos, is evidence of our originality and skill. Allow your
            imagination to be sparked and inspired by our work.
          </p>
        </div>
      </div>
    </div>
  </div>

  <div class="container">
    <div class="row mb-4">
      <div class="col-12">
        <div class="works_nav">
          <ul class="works_navbar">
            <li><a href="javascript:void(0);" data-filter="logo">Logo Design</a></li>
            <li><a href="javascript:void(0);" data-filter="web">Web Design</a></li>
            <li><a href="javascript:void(0);" data-filter="illustration">Illustration Design</a></li>
            <li><a href="javascript:void(0);" data-filter="app">App Design</a></li>
            <li><a href="javascript:void(0);" data-filter="motion">Motion Graphics</a></li>
            <li><a href="javascript:void(0);" data-filter="all" class="refresh"><i class="fas fa-sync-alt"></i></a></li>
          </ul>
        </div>
      </div>
    </div>
    <div class="row mt--50 mt-md-3-0 mt-xs--30">
      <?php foreach ($portfolio_items as $index => $item): ?>
        <?php
        $animation = $animations[$index % count($animations)];
        $duration = ($index + 1) * 0.5 . 's';
        // Hide items beyond the first six if not on the portfolio page
        $extra_class = ($current_page !== 'portfolio' && $index >= 6) ? 'default-hidden' : '';
        ?>
        <div class="work_item col-lg-6 item-center <?= $extra_class; ?>" data-category="<?= $item['category']; ?>">
          <div class="portfolio-style-one animate" data-animate="<?= $animation; ?>" data-duration="<?= $duration; ?>">
            <div class="work_zoom thumb-zoom position-relative">
              <img src="<?= $item['image']; ?>" alt="Image Not Found">
              <?php if (!empty($item['video'])): ?>
                <video src="<?= $item['video']; ?>" muted playsinline loop></video>
              <?php endif; ?>
            </div>
            <div class="pf-item-info">
              <div class="content-info">
                <h2><a href="<?= $item['link']; ?>"><?= $item['title']; ?></a></h2>
              </div>
              <div class="button">
                <a href="<?= $item['link']; ?>" class="pf-btn"><i class="fas fa-arrow-right"></i></a>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
