<?php
$activePage = substr($_SERVER['SCRIPT_NAME'], strrpos($_SERVER['SCRIPT_NAME'], "/") + 1);
if (isset($servicesContentPath)) {
  include($servicesContentPath);
} else {
  include("services_content.php");
}

?>

<header class="overflow-hidden">
  <!-- Start Navigation -->
  <nav
    class="navbar mobile-sidenav navbar-sticky navbar-default validnavs navbar-fixed no-background <?php echo $navClass; ?>">


    <div class="container-fluid px-5 d-flex justify-content-between align-items-center">


      <!-- Start Header Navigation -->
      <div class="navbar-header">
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
          <i class="fa fa-bars"></i>
        </button>
        <a class="navbar-brand" href="index.html">
          <img id="navLogo" src="assets/img/logo/04.png" class="logo" alt="Logo">
        </a>
      </div>
      <!-- End Header Navigation -->

      <!-- Collect the nav links, forms, and other content for toggling -->
      <div class="collapse navbar-collapse" id="navbar-menu">

        <img id="navLogo" src="assets/img/logo/06.png" alt="Logo">
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
          <i class="fa fa-times"></i>
        </button>

        <ul class="nav navbar-nav navbar-center" data-in="fadeInDown" data-out="fadeOutUp">
          <li>
            <a href="index.php" class="<?= $activePage == 'index.php' ? 'active' : ''; ?>">Home</a>
          </li>
          <li class="dropdown">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">Services</a>
            <ul class="dropdown-menu">
              <div class="row mx-0">
                <div class="col-lg-9 p-0">
                  <div class="dropdown_left">
                    <div class="row mx-0">
                      <?php foreach ($services as $service) : ?>
                        <div class="col-lg-4 px-1 my-1">
                          <a href="<?= $service['link']; ?>" class="d-flex dropdown-item">
                            <img src="assets/img/icon/<?= $service['nav_icon']; ?>" alt="">
                            <div class="drop_text">
                              <h4><?= $service['title']; ?></h4>
                              <p><?= $service['nav_text']; ?></p>
                            </div>
                          </a>
                        </div>
                      <?php endforeach; ?>
                    </div>
                  </div>
                  <hr class="dropdown-hr">
                </div>
                <div class="col-lg-3 p-0">
                  <div class="dropdown_right"></div>
                </div>
                <div class="col-12">
                  <div class="dropdown_footer">
                    <div class="df_text">
                      <h3>Want to know if Savvy Design Hub is a good fit?</h3>
                      <p>
                        Book a quick demo and let us answer all your questions!
                      </p>
                    </div>
                    <form action="">
                      <input type="email" class="form-control" placeholder="Your Email">
                      <i class="fa fa-envelope"></i>
                      <a type="submit" class="btn btn-dark">Get Started</a>
                    </form>
                  </div>
                </div>
              </div>
            </ul>
          </li>
          <li><a href="portfolio.php" class="<?= $activePage == 'portfolio.php' ? 'active' : ''; ?>">Portfolio</a></li>
          <li><a href="pricing.php" class="<?= $activePage == 'pricing.php' ? 'active' : ''; ?>">Pricing</a></li>
          <li><a href="about-us.php" class="<?= $activePage == 'about-us.php' ? 'active' : ''; ?>">About Us</a></li>
        </ul>
      </div><!-- /.navbar-collapse -->

      <div class="attr-right d-flex align-items-center justify-content-between">
        <a href="contact.php" class="btn btn-nav-r">contact <span><img src="assets/img/icon/arrow-up.png"
              alt=""></span></a>
        <!-- Start Atribute Navigation -->
        <div class="attr-nav flex">
          <ul>
            <li class="side-menu">
              <a href="#">
                <span class="bar-1"></span>
                <span class="bar-2"></span>
                <span class="bar-3"></span>
              </a>
            </li>
          </ul>
        </div>
        <!-- End Atribute Navigation -->


        <!-- Start Side Menu -->
        <div class="side">
          <a href="#" class="close-side"><i class="fas fa-times"></i></a>
          <div class="widget">
            <div class="logo">
              <img src="assets/img/logo/04.png" alt="Logo">
            </div>
          </div>
          <div class="widget">
            <p>
              Digital marketing is the component of marketing that uses the Internet and online based digital
              technologies such as desktop computers, mobile phones and other digital media and platforms to promote
              products and services.
            </p>
          </div>
          <div class="widget address">
            <div>
              <ul>
                <li>
                  <div class="content">
                    <p>Address</p>
                    <strong>California, TX 70240</strong>
                  </div>
                </li>
                <li>
                  <div class="content">
                    <p>Email</p>
                    <strong>support@validtheme.com</strong>
                  </div>
                </li>
                <li>
                  <div class="content">
                    <p>Contact</p>
                    <strong>+44-20-7328-4499</strong>
                  </div>
                </li>
              </ul>
            </div>
          </div>
          <div class="widget newsletter">
            <h4 class="title">Get Subscribed!</h4>
            <form action="#">
              <div class="input-group stylish-input-group">
                <input type="email" placeholder="Enter your e-mail" class="form-control" name="email">
                <span class="input-group-addon">
                  <button type="submit">
                    <i class="fas fa-arrow-right"></i>
                  </button>
                </span>
              </div>
            </form>
          </div>
          <div class="widget social">
            <ul class="link">
              <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
              <li><a href="#"><i class="fab fa-twitter"></i></a></li>
              <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
              <li><a href="#"><i class="fab fa-behance"></i></a></li>
            </ul>
          </div>

        </div>
        <!-- End Side Menu -->

      </div>
      <!-- Main Nav -->

    </div>
    <!-- Overlay screen for menu -->
    <div class="overlay-screen"></div>
    <!-- End Overlay screen for menu -->
  </nav>
  <!-- End Navigation -->
</header>
