<?php
$current_page = basename($_SERVER['PHP_SELF'], ".php");

$hero_data = match ($current_page) {
  'index' => [
    '$hero_title' => 'Transforming Data into Dynamic Digital Experiences',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'logo-design' => [
    '$hero_title' => 'Logo Design',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'website-design' => [
    '$hero_title' => 'Website Design',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'illustration-design' => [
    '$hero_title' => 'Illustration Design',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'application-design' => [
    '$hero_title' => 'Application Design',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'creative-copywriting' => [
    '$hero_title' => 'Creative Copywriting',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'seo-services' => [
    '$hero_title' => 'SEO Services',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'ecommerce-web-solutions' => [
    '$hero_title' => 'Ecommerce Web Solutions',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'marketing-collateral' => [
    '$hero_title' => 'Marketing Collateral',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  'motion-graphics' => [
    '$hero_title' => 'Motion Graphics',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
  default => [
    '$hero_title' => 'Savy Design Hub',
    '$hero_desc' => 'We bring your data to life. We specialize in creating websites, mobile apps, and digital marketing strategies.',
  ],
};

$hero_title = $hero_data['$hero_title'];

$hero_desc = $hero_data['$hero_desc'];
?>

<section class="hero-sec">
  <div class="video-wrap">
    <video muted autoplay loop class="custom-video">
      <source src="assets/videos/front-page-video-compress.mp4" type="video/mp4">
      "Your browser does not support the video tag."
    </video>
  </div>
  <div class="container">
    <div class="row align-items-center justify-content-between">
      <div class="col-lg-6">
        <div class="hero-content">
          <h4>Savy Design Hub</h4>
          <h1 class="title text-white"><?= $hero_title ?></h1>
          <p><?= $hero_desc ?></p>
          <a class="btn-animation" href="contact">
            <i class="fas fa-arrow-right"></i>
            <span>Let's Get Started</span>
          </a>
        </div>
      </div>
      <div class="col-lg-5">
        <div class="hero-form">
          <form action="">
            <h2>Get Consultation Now!</h2>
            <div class="row justify-content-center">
              <div class="col-12 col-lg-6 py-1 px-1">
                <div class="wave-form">
                  <input type="text" id="fname" class="input">
                  <span class="bar"></span>
                  <label for="fname" class="label">Your First Name</label>
                </div>
              </div>
              <div class="col-12 col-lg-6 py-1 px-1">
                <div class="wave-form">
                  <input type="text" id="lname" class="input">
                  <span class="bar"></span>
                  <label for="lname" class="label">Your Last Name</label>
                </div>
              </div>
              <div class="col-12 col-lg-12 py-1 px-1">
                <div class="wave-form">
                  <input type="email" id="email" class="input">
                  <span class="bar"></span>
                  <label for="email" class="label">Your Email Address</label>
                </div>
              </div>
              <div class="col-12 col-lg-12 py-1 px-1">
                <div class="wave-form">
                  <input type="tel" id="phone" class="input">
                  <span class="bar"></span>
                  <label for="phone" class="label">Your Phone Number</label>
                </div>
              </div>
              <div class="col-12 col-lg-12 py-1 px-1">
                <div class="wave-form">
                  <textarea rows="3" id="message" style="resize: none;" class="input"></textarea>
                  <span class="bar"></span>
                  <label for="message" class="label">Your Message</label>
                </div>
              </div>
              <div class="col-12 col-lg-12 py-1 pt-3 px-1">
                <button type="submit" class="btn btn-primary w-100">Get Consultation</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php include 'components/banner-dark.php'; ?>
</section>