
function fromOpacityScale() {

  let elements = document.querySelectorAll('[data-gsap="fromOpacityScale"]');

  elements.forEach(ele => {

    // animation values
    let y_axisVal = ele.getAttribute('data-gsap-y') ?? '100%';

    let x_axisVal = ele.getAttribute('data-gsap-x') ?? '0';

    let opacityVal = ele.getAttribute('data-gsap-opacity') ?? 0;

    let easeVal = ele.getAttribute('data-gsap-ease') ?? "power1.out";

    let durationVal = ele.getAttribute('data-gsap-duration') ?? 2;

    let delayVal = ele.getAttribute('data-gsap-delay') ?? 0;

    // animation
    let anim = gsap.from(ele, {
      y: y_axisVal,
      x: x_axisVal,
      autoAlpha: opacityVal,
      ease: easeVal,
      duration: durationVal,
      delay: delayVal,
    });

    // scroll values
    let startVal = ele.getAttribute('data-gsap-start') ?? "top bottom";

    let endVal = ele.getAttribute('data-gsap-end') ?? "center 70%";

    let scrubVal = ele.getAttribute('data-gsap-scrub') ?? 2;

    let onceVal = ele.getAttribute('data-gsap-once') ?? true;

    let immediateRenderVal = ele.getAttribute('data-gsap-immediaterender') ?? false;

    let markersVal = ele.getAttribute('data-gsap-markers') ?? false;

    // scroll
    ScrollTrigger.create({
      animation: anim,
      trigger: ele,
      start: startVal,
      end: endVal,
      scrub: scrubVal,
      once: onceVal,
      immediateRender: immediateRenderVal,
      markers: markersVal
    });

  });

} // .function

document.addEventListener("DOMContentLoaded", function (e) {
  fromOpacityScale();
});

gsap.from('.hero-form', {
  x: '100%',
  autoAlpha: 0,
  ease: "power1.out",
  duration: 1,
  delay: 0,
});
